<!DOCTYPE html>
<html lang="xxx" dir="<?php echo e($currentLanguageInfo->direction == 1 ? 'rtl' : ''); ?>">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="author" content="KreativDev">

  <meta name="keywords" content="<?php echo $__env->yieldContent('metaKeywords'); ?>">
  <meta name="description" content="<?php echo $__env->yieldContent('metaDescription'); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
  <!-- Title -->
  <title><?php echo $__env->yieldContent('pageHeading'); ?> <?php echo e('| ' . $websiteInfo->website_title); ?></title>
  <!-- Favicon -->
  <link rel="shortcut icon" href="<?php echo e(asset('assets/img/' . $websiteInfo->favicon)); ?>" type="image/x-icon">
  <link rel="apple-touch-icon" href="<?php echo e(asset('assets/img/' . $websiteInfo->favicon)); ?>">

  <!-- Google font -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/font.css')); ?>">
  <?php
    $primaryColor = $basicInfo->primary_color;
    $secondaryColor = $basicInfo->secondary_color;

    // check, whether color has '#' or not, will return 0 or 1
    if (!function_exists('checkColorCode')) {
        function checkColorCode($color)
        {
            return preg_match('/^#[a-f0-9]{6}/i', $color);
        }
    }

    // if, primary color value does not contain '#', then add '#' before color value
    if (isset($primaryColor) && checkColorCode($primaryColor) == 0) {
        $primaryColor = '#' . $primaryColor;
    }
    // if, secondary color value does not contain '#', then add '#' before color value
    if (isset($secondaryColor) && checkColorCode($secondaryColor) == 0) {
        $secondaryColor = '#' . $secondaryColor;
    }

    // change decimal point into hex value for opacity
    if (!function_exists('rgb')) {
        function rgb($color = null)
        {
            if (!$color) {
                echo '';
            }
            $hex = htmlspecialchars($color);
            [$r, $g, $b] = sscanf($hex, '#%02x%02x%02x');
            echo "$r, $g, $b";
        }
    }
  ?>

  <?php if ($__env->exists('frontend.partials.styles')) echo $__env->make('frontend.partials.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <style>
    :root {
      --color-primary: <?php echo e($primaryColor); ?>;
      --color-secondary: <?php echo e($secondaryColor); ?>;
      --color-primary-rgb: <?php echo e(rgb(htmlspecialchars($primaryColor))); ?>;
    }
  </style>
</head>


<body dir="<?php echo e($currentLanguageInfo->direction == 1 ? 'rtl' : ''); ?>">
  
  <div class="request-loader-time">
    <img src="<?php echo e(asset('assets/img/front-loader.gif')); ?>" alt="loader">
  </div>
  <?php if($basicInfo->preloader_status == 1): ?>
    <!-- Preloader start -->
    <div id="preLoader" data-preloader-status="<?php echo e($basicInfo->preloader_status); ?>">
      <img src="<?php echo e(asset('assets/img/' . $basicInfo->preloader)); ?>" alt="">
    </div>
  <?php endif; ?>
  

  <?php
    $theme_version = $basicInfo->theme_version;
  ?>

  <?php if($theme_version == 1): ?>
    <?php if ($__env->exists('frontend.partials.header.header-v1')) echo $__env->make('frontend.partials.header.header-v1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($theme_version == 2): ?>
    <?php if ($__env->exists('frontend.partials.header.header-v2')) echo $__env->make('frontend.partials.header.header-v2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php elseif($theme_version == 3): ?>
    <?php if ($__env->exists('frontend.partials.header.header-v3')) echo $__env->make('frontend.partials.header.header-v3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>



  <?php if(request()->routeIs('index')): ?>
  <?php endif; ?>

  <?php echo $__env->yieldContent('breadcrumb'); ?>

  <?php echo $__env->yieldContent('content'); ?>
  <div id="razorPayForm"></div>
  <?php if ($__env->exists('frontend.partials.popups')) echo $__env->make('frontend.partials.popups', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <?php if ($__env->exists('frontend.partials.footer')) echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  
  <?php if(!is_null($cookieAlertInfo) && $cookieAlertInfo->cookie_alert_status == 1): ?>
    <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php endif; ?>

  <div class="floating-btns">
    <!-- WhatsApp Chat Button -->
    <div id="WAButton"></div>
  </div>

  <?php if($basicInfo->shop_status == 1): ?>
    <!-- Floating Cart Button -->
    <div id="cartIconWrapper" class="cartIconWrapper">
      <?php
        $position = $basicInfo->base_currency_symbol_position;
        $symbol = $basicInfo->base_currency_symbol;
        $totalPrice = 0;
        if (session()->has('productCart')) {
            $productCarts = session()->get('productCart');
            foreach ($productCarts as $key => $product) {
                $totalPrice += $product['price'];
            }
        }
        $totalPrice = number_format($totalPrice);
        $productCartQuantity = 0;
        if (session()->has('productCart')) {
            foreach (session()->get('productCart') as $value) {
                $productCartQuantity = $productCartQuantity + $value['quantity'];
            }
        }
      ?>
      <a href="<?php echo e(route('shop.cart')); ?> " class="d-block" id="cartIcon">
        <div class="cart-length">
          <i class="fal fa-shopping-bag"></i>
          <span class="length totalItems">
            <?php echo e($productCartQuantity); ?> <?php echo e(__('Items')); ?>

          </span>
        </div>
        <div class="cart-total">
          <?php echo e($position == 'left' ? $symbol : ''); ?><span
            class="totalPrice"><?php echo e($totalPrice); ?></span><?php echo e($position == 'right' ? $symbol : ''); ?>

        </div>
      </a>
    </div>
    <!-- Floating Cart Button End-->
  <?php endif; ?>
  <?php if ($__env->exists('frontend.partials.scripts')) echo $__env->make('frontend.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php if ($__env->exists('frontend.partials.toastr')) echo $__env->make('frontend.partials.toastr', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /Users/samiulalimpratik/Sites/bookapp/bookapp/resources/views/frontend/layout.blade.php ENDPATH**/ ?>