<?php
  $version = $basicInfo->theme_version;
?>

<?php $__env->startSection('pageHeading'); ?>
  <?php echo e(__('Home')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaKeywords'); ?>
  <?php if(!empty($seoInfo)): ?>
    <?php echo e($seoInfo->meta_keyword_home); ?>

  <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('metaDescription'); ?>
  <?php if(!empty($seoInfo)): ?>
    <?php echo e($seoInfo->meta_description_home); ?>

  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
  <!-- Home-area start-->
  <section class="hero-banner hero-banner-1 parallax">
    <div class="container container-lg-fluid">
      <div class="row align-items-center gx-xl-5">
        <div class="col-lg-7">
          <div class="fluid-left">
            <div class="banner-content mb-40">
              <h1 class="title mb-30" data-aos="fade-up" data-aos-delay="100">
                <?php echo e(!empty($sectionContent->hero_section_title) ? $sectionContent->hero_section_title : 'Find Anything From Nearest Location To Make A Booking'); ?>

              </h1>
              <p class="text" data-aos="fade-up" data-aos-delay="100">
                <?php echo e(!empty($sectionContent->hero_section_subtitle) ? $sectionContent->hero_section_subtitle : 'Link Build is an advanced and modern-looking directory script with rich SEO features where you can create your.'); ?>

              </p>
              <div class="banner-filter-form mt-40" data-aos="fade-up" data-aos-delay="150">
                <div class="form-wrapper shadow-md bg-white p-20 radius-md">
                  <form id="homepage_search" action="<?php echo e(route('frontend.services')); ?>" method="get">
                    <div class="row justify-content-center align-items-center">
                      <div class="col-md-4 col-sm-6">
                        <div class="input-group">
                          <label for="service_location" class="text-gradient"><i
                              class="fal fa-map-marker-alt"></i></label>
                          <input type="text" id="service_location" name="location" class="form-control"
                            placeholder="<?php echo e(__('Search By Location')); ?>">
                          <div class="vr"></div>
                        </div>
                      </div>
                      <div class="col-md-4 col-sm-6">
                        <div class="input-group">
                          <label for="service_title" class="text-gradient"><i class="fal fa-clipboard-list"></i></label>
                          <input type="text" id="service_name" name="service_title" class="form-control"
                            placeholder="<?php echo e(__('Search Service')); ?>">
                        </div>
                      </div>
                      <div class="col-lg-4 col-md-4 col-sm-6">
                        <button type="submit" class="btn btn-lg btn-primary icon-start w-100">
                          <i class="fal fa-search"></i>
                          <?php echo e(__('Find Now')); ?>

                        </button>
                      </div>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-lg-5" data-aos="fade-up">
          <div class="banner-image mb-40 parallax-img" data-speed="0.5" data-revert="true">
            <img class="lazyload blur-up" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
              data-src="<?php echo e(asset('assets/img/hero/' . @$sectionContent->hero_section_background_img)); ?>"
              alt="Banner Image">
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- Home-area end -->
  <?php if(count($after_hero) > 0): ?>
    <?php $__currentLoopData = $after_hero; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusHero): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusHero->id])): ?>
        <?php if($homecusSec[$cusHero->id] == 1): ?>
          <?php
            $cusHeroContent = App\Models\CustomSectionContent::where('custom_section_id', $cusHero->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusHeroContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Category-area start -->
  <?php if($secInfo->category_section_status == 1): ?>
    <section class="category-area category-1 pb-100">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title title-center mb-50" data-aos="fade-up">
              <h2 class="title mb-0">
                <?php echo e(!empty($sectionContent->category_section_title) ? $sectionContent->category_section_title : 'Most Popular Categories'); ?>

              </h2>
            </div>
          </div>
          <div class="col-12" data-aos="fade-up">
            <?php if(count($categories) == 0): ?>
              <h4 class="text-center"><?php echo e(__('NO CATEGORIES FOUND')); ?>!</h4>
            <?php else: ?>
              <div class="swiper category-slider" id="category-slider-1" data-slides-per-view="5"
                data-swiper-loop="false">
                <div class="swiper-wrapper">
                  <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <style>
                      .category-area.category-1 .swiper-slide .card-icon.icon-bg<?php echo e($loop->iteration); ?> {
                        background-color: #<?php echo e($category->background_color); ?>;
                        box-shadow: 0 15px 30px -12px rgba(<?php echo e(hexdec(substr($category->background_color, 0, 2))); ?>, <?php echo e(hexdec(substr($category->background_color, 2, 2))); ?>, <?php echo e(hexdec(substr($category->background_color, 4, 2))); ?>, 0.7);
                      }

                      .category-area.category-1 .swiper-slide .card:hover .card-title.title-hover<?php echo e($loop->iteration); ?> {
                        color: #<?php echo e($category->background_color); ?>;
                      }
                    </style>
                    <a href="<?php echo e(route('frontend.services', ['category' => $category->slug])); ?>" target="_self">
                      <div class="swiper-slide">
                        <div class="card p-25 border radius-md text-center">
                          <div class="card-icon icon-bg<?php echo e($loop->iteration); ?> radius-md mx-auto mb-20">
                            <i class="<?php echo e($category->icon); ?>"></i>
                          </div>
                          <h4 class="card-title title-hover<?php echo e($loop->iteration); ?> lc-1 mb-1">
                            <a href="<?php echo e(route('frontend.services', ['category' => $category->slug])); ?>" target="_self"
                              title="<?php echo e($category->name); ?>">
                              <?php echo e($category->name); ?>

                            </a>
                          </h4>
                          <span class="font-sm">
                            <?php if($category->service_count > 1): ?>
                              <?php echo e($category->service_count); ?>

                              <?php echo e(__('Services Available')); ?>

                            <?php elseif($category->service_count == 1): ?>
                              <?php echo e($category->service_count); ?>

                              <?php echo e(__('Service Available')); ?>

                            <?php endif; ?>
                          </span>
                        </div>
                      </div>
                    </a>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="swiper-pagination position-static mt-40" id="category-slider-1-pagination"></div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Category-area end -->
  <?php if(count($after_category) > 0): ?>
    <?php $__currentLoopData = $after_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusCategory->id])): ?>
        <?php if($homecusSec[$cusCategory->id] == 1): ?>
          <?php
            $cusCategoryContent = App\Models\CustomSectionContent::where('custom_section_id', $cusCategory->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusCategoryContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Works-area start -->
  <?php if($secInfo->work_process_section_status == 1): ?>
    <section class="works-area works-1 pt-100 pb-60 bg-img bg-cover"
      data-bg-image="<?php echo e(!empty($sectionContent->work_process_background_img) ? asset('assets/img/' . $sectionContent->work_process_background_img) : asset('assets/frontend/images/work-process.png')); ?>">

      <div class="container">
        <div class="row align-items-center gx-xl-5">
          <div class="col-lg-5">
            <div class="content-title mb-40" data-aos="fade-up">
              <h2 class="title mb-25 color-white">
                <?php echo e(!empty($sectionContent->workprocess_section_title) ? $sectionContent->workprocess_section_title : 'How appointment Booking System Works'); ?>

              </h2>
              <p class="color-white">
                <?php echo e(!empty($sectionContent->workprocess_section_subtitle) ? $sectionContent->workprocess_section_subtitle : 'Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind. '); ?>

              </p>
              <?php if(!empty($sectionContent->workprocess_section_url)): ?>
                <div class="mt-30">
                  <a href="<?php echo e(@$sectionContent->workprocess_section_url); ?>"
                    class="btn btn-lg btn-primary btn-gradient icon-start">
                    <i class="<?php echo e(@$sectionContent->workprocess_icon); ?>"></i>
                    <?php echo e(@$sectionContent->workprocess_section_btn); ?>

                  </a>
                </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-lg-7">
            <div class="swiper works-slider mb-40" id="works-slider-1" data-aos="fade-up">
              <div class="swiper-wrapper">
                <?php $__currentLoopData = $processes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $processe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <style>
                    .works-area.works-1 .swiper-slide .card.card-bg<?php echo e($loop->iteration); ?> {
                      background-color: #<?php echo e($processe->background_color); ?>;
                      background-image: linear-gradient(-35deg, #<?php echo e($processe->background_color); ?> 0%, #021B79 100%);
                    }
                  </style>
                  <div class="swiper-slide">
                    <div class="card card-bg<?php echo e($loop->iteration); ?> p-30 radius-lg">
                      <div class="card-icon color-white">
                        <i class="<?php echo e($processe->icon); ?>"></i>
                      </div>
                      <div class="line bg-white my-3 rounded-pill"></div>
                      <h4 class="card-title color-white lc-1 mb-15">
                        <?php echo e($processe->title); ?>

                      </h4>
                      <p class="card-text color-light">
                        <?php echo e($processe->text); ?>

                      </p>
                    </div>
                  </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
              <div class="swiper-pagination position-static mt-30" id="works-slider-1-pagination"></div>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Works-area end -->
  <?php if(count($after_work_process) > 0): ?>
    <?php $__currentLoopData = $after_work_process; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $work_process): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$work_process->id])): ?>
        <?php if($homecusSec[$work_process->id] == 1): ?>
          <?php
            $work_processContent = App\Models\CustomSectionContent::where('custom_section_id', $work_process->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $work_processContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Service-area start -->
  <?php if($secInfo->feature_section_status == 1): ?>
    <section class="service-area service-1 ptb-100">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title title-inline mb-50" data-aos="fade-up">
              <h2 class="title">
                <?php echo e(!empty($sectionContent->featured_service_section_title) ? $sectionContent->featured_service_section_title : 'Our Top Featured Services'); ?>

              </h2>
              <!-- Slider navigation buttons -->
              <?php if($featured_services->count() > 4): ?>
                <div class="slider-navigation">
                  <button type="button" title="Slide prev" class="slider-btn" id="product-slider-1-prev">
                    <i class="fal fa-angle-left"></i>
                  </button>
                  <button type="button" title="Slide next" class="slider-btn" id="product-slider-1-next">
                    <i class="fal fa-angle-right"></i>
                  </button>
                </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-12">
            <?php if($featured_services->count() == 0): ?>
              <h4 class="text-center"><?php echo e(__('NO SERVICE FOUND') . '!'); ?></h4>
            <?php else: ?>
              <!-- Slider main container -->
              <div class="swiper product-slider" id="product-slider-1" data-slides-per-view="4"
                data-swiper-loop="false" data-aos="fade-up">
                <!-- Additional required wrapper -->
                <div class="swiper-wrapper">
                  <?php $__currentLoopData = $featured_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!-- Slides -->
                    <div class="swiper-slide">
                      <div class="product-default border radius-md p-15 mb-25">
                        <figure class="product-img mb-15">
                          <a href="<?php echo e(route('frontend.service.details', ['slug' => $service->slug, 'id' => $service->id])); ?>"
                            title="Image" target="_self" class="lazy-container radius-sm ratio ratio-2-3">
                            <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                              data-src="<?php echo e(asset('assets/img/services/' . $service->service_image)); ?>" alt="Service">
                          </a>
                        </figure>
                        <div class="product-details">
                          <div class="d-flex align-items-center justify-content-between gap-2">
                            <a href="<?php echo e(route('frontend.services', ['category_id' => $category->categoryId])); ?>">
                              <span class="tag font-sm"><?php echo e($service->categoryName); ?></span>
                            </a>
                            <?php if(Auth::guard('web')->check()): ?>
                              <?php
                                $user_id = Auth::guard('web')->user()->id;
                                $checkWishList = checkWishList($service->id, $user_id);
                              ?>
                            <?php else: ?>
                              <?php
                                $checkWishList = false;
                              ?>
                            <?php endif; ?>
                            <a href="<?php echo e($checkWishList == false ? route('addto.wishlist', $service->id) : route('remove.wishlist', $service->id)); ?>"
                              class="btn btn-icon border radius-sm <?php echo e($checkWishList == false ? '' : 'wishlist-active'); ?>"
                              data-tooltip="tooltip" data-bs-placement="right"
                              title="<?php echo e($checkWishList == false ? __('Save to Wishlist') : __('Saved')); ?>">
                              <i class="fal fa-heart"></i>
                            </a>

                          </div>
                          <h6 class="product-title mb-0">
                            <a href="<?php echo e(route('frontend.service.details', ['slug' => $service->slug, 'id' => $service->id])); ?>"
                              target="_self" title="<?php echo e($service->name); ?>">
                              <?php echo e(truncateString($service->name, 60)); ?>

                            </a>
                          </h6>
                          <input type="hidden" value="<?php echo e($service->language_id); ?>">
                          <div class="author mb-10 mt-10">
                            <?php if($service->vendor_id != 0): ?>
                              <?php if($service->vendor->photo != null): ?>
                                <a href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                  target="_self" title="<?php echo e($service->vendor->username); ?>">
                                  <img class="lazyload blur-up"
                                    src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                    data-src="<?php echo e(asset('assets/admin/img/vendor-photo/' . $service->vendor->photo)); ?>"
                                    alt="Image">
                                </a>
                              <?php else: ?>
                                <a href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                  target="_self" title="<?php echo e($service->vendor->username); ?>">
                                  <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                    data-src="<?php echo e(asset('assets/img/user.png')); ?>" alt="Vendor">
                                </a>
                              <?php endif; ?>
                              <span class="font-sm">
                                <?php echo e(__('By')); ?> <a
                                  href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                  target="_self"
                                  title="<?php echo e($service->vendor->username); ?>"><?php echo e($service->vendor->username); ?></a>
                              </span>
                            <?php else: ?>
                              <a href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username])); ?>"
                                target="_self" title="<?php echo e($admin->username); ?>">
                                <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                  data-src="<?php echo e(asset('assets/img/admins/' . $admin->image)); ?>" alt="Vendor">
                              </a>
                              <span class="font-sm">
                                <?php echo e(__('By')); ?> <a
                                  href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username])); ?>"
                                  target="_self" title="<?php echo e($admin->username); ?>"><?php echo e($admin->username); ?></a>
                              </span>
                            <?php endif; ?>
                          </div>
                          <?php if(!empty($service->address)): ?>
                            <span class="font-sm icon-start"><i
                                class="fal fa-map-marker-alt"></i><?php echo e(truncateString($service->address, 30)); ?></span>
                          <?php endif; ?>
                          <?php if($service->zoom_meeting == 1): ?>
                            <span class="font-sm icon-start"><i class="fal fa-video"></i><?php echo e(__('Online')); ?></span>
                          <?php endif; ?>
                          <div class="d-flex align-items-center justify-content-between gap-2 mt-10">
                            <div class="product-price">
                              <span class="h6 new-price"><?php echo e(symbolPrice($service->price)); ?></span>
                              <span
                                class="prev-price font-sm"><?php echo e($service->prev_price ? symbolPrice($service->prev_price) : ''); ?></span>
                            </div>
                            <a href="javaScript:void(0)" class="bookNowBtn btn btn-sm btn-outline-2"
                              data-bs-toggle="modal" data-bs-target="#makeBooking" data-id="<?php echo e($service->id); ?>"
                              title="Book Now" target="_self">
                              <?php echo e(__('Book Now')); ?></a>
                          </div>
                        </div>
                      </div><!-- product-default -->
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>

                <!-- If we need pagination -->
                <div class="swiper-pagination position-static" id="product-slider-1-pagination"></div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Service-area end -->
  <?php if(count($after_featured_service) > 0): ?>
    <?php $__currentLoopData = $after_featured_service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusFeature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusFeature->id])): ?>
        <?php if($homecusSec[$cusFeature->id] == 1): ?>
          <?php
            $cusFeatureContent = App\Models\CustomSectionContent::where('custom_section_id', $cusFeature->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusFeatureContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Action banner start -->
  <?php if($secInfo->call_to_action_section_status == 1): ?>
    <section class="action-banner">
      <div class="container">
        <div class="wrapper radius-md pt-40 px-60 bg-img bg-cover"
          data-bg-image="<?php echo e(asset('assets/img/' . @$sectionContent->call_to_action_section_image)); ?>">
          <div class="row align-items-center gx-xl-5">
            <div class="col-lg-6">
              <div class="content-title mb-40" data-aos="fade-up">
                <h2 class="title color-white mb-25">
                  <?php echo e(!empty($sectionContent->call_to_action_section_title) ? $sectionContent->call_to_action_section_title : ''); ?>

                </h2>
                <p class="color-light">
                  <?php echo e(!empty($sectionContent->action_section_text) ? $sectionContent->action_section_text : ''); ?></p>
                <?php if(!empty($sectionContent->call_to_action_url)): ?>
                  <div class="mt-30">
                    <a href="<?php echo e(@$sectionContent->call_to_action_url); ?>"
                      class="btn btn-lg btn-primary btn-gradient icon-start"><i
                        class="<?php echo e(@$sectionContent->call_to_action_icon); ?>"></i><?php echo e(@$sectionContent->call_to_action_section_btn); ?></a>
                  </div>
                <?php endif; ?>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="image mb-40" data-aos="fade-left">
                <img class="lazyload blur-up" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                  data-src="<?php echo e(asset('assets/img/' . @$sectionContent->call_to_action_section_inner_image)); ?>"
                  alt="Image">
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Action banner end -->
  <?php if(count($after_call_to_action) > 0): ?>
    <?php $__currentLoopData = $after_call_to_action; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusAction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusAction->id])): ?>
        <?php if($homecusSec[$cusAction->id] == 1): ?>
          <?php
            $cusActionContent = App\Models\CustomSectionContent::where('custom_section_id', $cusAction->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusActionContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Service-area start -->
  <?php if($secInfo->latest_service_section_status == 1): ?>
    <section class="service-area service-1 ptb-100">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title title-center mb-50" data-aos="fade-up">
              <h2 class="title mb-20">
                <?php echo e(!empty($sectionContent->latest_service_section_title) ? $sectionContent->latest_service_section_title : 'Most Popular Booking Services We Offer'); ?>

              </h2>
              <?php if(count($categories) > 0): ?>
                <div class="tabs-navigation">
                  <ul class="nav nav-tabs" data-hover="fancyHover">
                    <li class="nav-item active">
                      <button class="nav-link hover-effect active btn-md radius-sm" data-bs-toggle="tab"
                        data-bs-target="#forAll" type="button"><?php echo e(__('All Services')); ?></button>
                    </li>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <li class="nav-item">
                        <button class="nav-link hover-effect btn-md radius-sm" data-bs-toggle="tab"
                          data-bs-target="#serviceTab<?php echo e($category->id); ?>"
                          type="button"><?php echo e($category->name); ?></button>
                      </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
                </div>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-12">
            <?php if(count($services) == 0): ?>
              <h4 class="text-center"><?php echo e(__('NO SERVICE FOUND')); ?>!</h4>
            <?php else: ?>
              <div class="tab-content" data-aos="fade-up">
                <div class="tab-pane fade show active" id="forAll">
                  <div class="row">
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="col-xl-3 col-lg-4 col-sm-6" data-aos="fade-up">
                        <div class="product-default border radius-md p-15 mb-25">
                          <figure class="product-img mb-15">
                            <a href="<?php echo e(route('frontend.service.details', ['slug' => $service->slug, 'id' => $service->id])); ?>"
                              title="Image" target="_self" class="lazy-container radius-sm ratio ratio-2-3">
                              <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                data-src="<?php echo e(asset('assets/img/services/' . $service->service_image)); ?>"
                                alt="Service">
                            </a>

                          </figure>
                          <div class="product-details">
                            <div class="d-flex align-items-center justify-content-between gap-2">
                              <a href="<?php echo e(route('frontend.services', ['category_id' => $service->categoryId])); ?>">
                                <span class="tag font-sm"><?php echo e($service->categoryName); ?></span>
                              </a>
                              <?php if(Auth::guard('web')->check()): ?>
                                <?php
                                  $user_id = Auth::guard('web')->user()->id;
                                  $checkWishList = checkWishList($service->id, $user_id);
                                ?>
                              <?php else: ?>
                                <?php
                                  $checkWishList = false;
                                ?>
                              <?php endif; ?>
                              <a href="<?php echo e($checkWishList == false ? route('addto.wishlist', $service->id) : route('remove.wishlist', $service->id)); ?>"
                                class="btn btn-icon border radius-sm <?php echo e($checkWishList == false ? '' : 'wishlist-active'); ?>"
                                data-tooltip="tooltip" data-bs-placement="right"
                                title="<?php echo e($checkWishList == false ? __('Save to Wishlist') : __('Saved')); ?>">
                                <i class="fal fa-heart"></i>
                              </a>
                            </div>
                            <h6 class="product-title mb-0">
                              <a href="<?php echo e(route('frontend.service.details', ['slug' => $service->slug, 'id' => $service->id])); ?>"
                                target="_self">
                                <?php echo e(truncateString($service->name, 60)); ?>

                              </a>
                            </h6>
                            <input type="hidden" value="<?php echo e($service->language_id); ?>">
                            <div class="author mb-10 mt-10">
                              <?php if($service->vendor_id != 0): ?>
                                <?php if($service->vendor->photo != null): ?>
                                  <a href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                    target="_self" title="<?php echo e($service->vendor->username); ?>">
                                    <img class="lazyload blur-up"
                                      src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                      data-src="<?php echo e(asset('assets/admin/img/vendor-photo/' . $service->vendor->photo)); ?>"
                                      alt="Image">
                                  </a>
                                <?php else: ?>
                                  <a href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                    target="_self" title="<?php echo e($service->vendor->username); ?>">
                                    <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                      data-src="<?php echo e(asset('assets/img/user.png')); ?>" alt="Vendor">
                                  </a>
                                <?php endif; ?>
                                <span class="font-sm">
                                  <?php echo e(__('By')); ?> <a
                                    href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                    target="_self"
                                    title="<?php echo e($service->vendor->username); ?>"><?php echo e($service->vendor->username); ?></a>
                                </span>
                              <?php else: ?>
                                <a href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username])); ?>"
                                  target="_self" title="<?php echo e($admin->username); ?>">
                                  <img class="lazyload blur-up"
                                    src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                    data-src="<?php echo e(asset('assets/img/admins/' . $admin->image)); ?>" alt="Image">
                                </a>
                                <span class="font-sm">
                                  <?php echo e(__('By')); ?> <a
                                    href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username])); ?>"
                                    target="_self" title="<?php echo e($admin->username); ?>"><?php echo e($admin->username); ?></a>
                                </span>
                              <?php endif; ?>
                            </div>
                            <?php if(!empty($service->address)): ?>
                              <span class="font-sm icon-start"><i
                                  class="fal fa-map-marker-alt"></i><?php echo e(truncateString($service->address, 30)); ?></span>
                            <?php endif; ?>
                            <?php if($service->zoom_meeting == 1): ?>
                              <span class="font-sm icon-start"><i class="fal fa-video"></i><?php echo e(__('Online')); ?></span>
                            <?php endif; ?>
                            <div class="d-flex align-items-center justify-content-between gap-2 mt-10">
                              <div class="product-price">
                                <span class="h6 new-price"><?php echo e(symbolPrice($service->price)); ?></span>
                                <span
                                  class="prev-price font-sm"><?php echo e($service->prev_price ? symbolPrice($service->prev_price) : ''); ?></span>
                              </div>
                              <a href="javaScript:void(0)" class="bookNowBtn btn btn-sm btn-outline-2"
                                data-bs-toggle="modal" data-bs-target="#makeBooking" data-id="<?php echo e($service->id); ?>"
                                title="Book Now" target="_self">
                                <?php echo e(__('Book Now')); ?></a>
                            </div>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                  <div class="cta-btn text-center mt-15">
                    <a href="<?php echo e(route('frontend.services')); ?>" class="btn btn-lg btn-primary btn-gradient icon-start"
                      title="View More" target="_self"><i class="fal fa-arrow-right"></i><?php echo e(__('View More')); ?></a>
                  </div>
                </div>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php
                    $vendorStatus = App\Models\Vendor::where('status', 1)->select('id')->get()->toArray();
                    $services = App\Models\Services\Services::join(
                        'service_contents',
                        'service_contents.service_id',
                        '=',
                        'services.id',
                    )
                        ->join('service_categories', 'service_categories.id', '=', 'service_contents.category_id')
                        ->where('service_contents.language_id', $language->id)
                        ->where('service_categories.language_id', $language->id)
                        ->where('service_contents.category_id', $category->id)
                        ->where(function ($query) use ($vendorStatus) {
                            $query->whereIn('services.vendor_id', $vendorStatus)->orWhere('services.vendor_id', 0);
                        })
                        ->when('services.vendor_id' != '0', function ($query) {
                            return $query
                                ->leftJoin('memberships', 'services.vendor_id', '=', 'memberships.vendor_id')
                                ->where(function ($query) {
                                    $query
                                        ->where([
                                            ['memberships.status', '=', 1],
                                            ['memberships.start_date', '<=', now()->format('Y-m-d')],
                                            ['memberships.expire_date', '>=', now()->format('Y-m-d')],
                                        ])
                                        ->orWhere('services.vendor_id', '=', 0);
                                });
                        })
                        ->select(
                            'services.*',
                            'service_contents.name',
                            'service_contents.address',
                            'service_contents.slug',
                        )
                        ->paginate(8);
                  ?>
                  <?php if(count($services) > 0): ?>
                    <div class="tab-pane fade" id="serviceTab<?php echo e($category->id); ?>">
                      <div class="row">
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="col-xl-3 col-lg-4 col-sm-6" data-aos="fade-up">
                            <div class="product-default border radius-md p-15 mb-25">
                              <figure class="product-img mb-15">
                                <a href="<?php echo e(route('frontend.service.details', ['slug' => $service->slug, 'id' => $service->id])); ?>"
                                  title="Image" target="_self" class="lazy-container radius-sm ratio ratio-2-3">
                                  <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                    data-src="<?php echo e(asset('assets/img/services/' . $service->service_image)); ?>"
                                    alt="Service">
                                </a>

                              </figure>
                              <div class="product-details">
                                <div class="d-flex align-items-center justify-content-between gap-2">
                                  <a href="<?php echo e(route('frontend.services', ['category_id' => $category->id])); ?>">
                                    <span class="tag font-sm"><?php echo e(@$category->name); ?></span>
                                  </a>
                                  <?php if(Auth::guard('web')->check()): ?>
                                    <?php
                                      $user_id = Auth::guard('web')->user()->id;
                                      $checkWishList = checkWishList($service->id, $user_id);
                                    ?>
                                  <?php else: ?>
                                    <?php
                                      $checkWishList = false;
                                    ?>
                                  <?php endif; ?>
                                  <a href="<?php echo e($checkWishList == false ? route('addto.wishlist', $service->id) : route('remove.wishlist', $service->id)); ?>"
                                    class="btn btn-icon border radius-sm <?php echo e($checkWishList == false ? '' : 'wishlist-active'); ?>"
                                    data-tooltip="tooltip" data-bs-placement="right"
                                    title="<?php echo e($checkWishList == false ? __('Save to Wishlist') : __('Saved')); ?>">
                                    <i class="fal fa-heart"></i>
                                  </a>
                                </div>
                                <h6 class="product-title mb-0">
                                  <a href="<?php echo e(route('frontend.service.details', ['slug' => $service->slug, 'id' => $service->id])); ?>"
                                    target="_self" title="<?php echo e($service->name); ?>">
                                    <?php echo e(truncateString($service->name, 60)); ?>

                                  </a>
                                </h6>
                                <div class="author mb-10 mt-10">
                                  <?php if($service->vendor_id != 0): ?>
                                    <?php if($service->vendor->photo): ?>
                                      <a href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                        target="_self" title="<?php echo e($service->vendor->username); ?>">
                                        <img class="lazyload blur-up"
                                          src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                          data-src="<?php echo e(asset('assets/admin/img/vendor-photo/' . $service->vendor->photo)); ?>"
                                          alt="Image">
                                      </a>
                                    <?php else: ?>
                                      <a href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                        target="_self" title="<?php echo e($service->vendor->username); ?>">
                                        <img class="lazyload"
                                          src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                          data-src="<?php echo e(asset('assets/img/user.png')); ?>" alt="Vendor">
                                      </a>
                                    <?php endif; ?>
                                    <span class="font-sm">
                                      <?php echo e(__('By')); ?> <a
                                        href="<?php echo e(route('frontend.vendor.details', ['username' => $service->vendor->username])); ?>"
                                        target="_self"
                                        title="<?php echo e($service->vendor->username); ?>"><?php echo e($service->vendor->username); ?></a>
                                    </span>
                                  <?php else: ?>
                                    <a href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username])); ?>"
                                      target="_self" title="<?php echo e($admin->username); ?>">
                                      <img class="lazyload blur-up"
                                        src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                        data-src="<?php echo e(asset('assets/img/admins/' . $admin->image)); ?>" alt="Image">
                                    </a>
                                    <span class="font-sm">

                                      <?php echo e(__('By')); ?> <a
                                        href="<?php echo e(route('frontend.vendor.details', ['username' => $admin->username])); ?>"
                                        target="_self" title="<?php echo e($admin->username); ?>"><?php echo e($admin->username); ?></a>
                                    </span>
                                  <?php endif; ?>
                                </div>
                                <?php if(!empty($service->address)): ?>
                                  <span class="font-sm icon-start"><i
                                      class="fal fa-map-marker-alt"></i><?php echo e(truncateString($service->address, 30)); ?></span>
                                <?php endif; ?>
                                <?php if($service->zoom_meeting == 1): ?>
                                  <span class="font-sm icon-start"><i
                                      class="fal fa-video"></i><?php echo e(__('Online')); ?></span>
                                <?php endif; ?>
                                <div class="d-flex align-items-center justify-content-between gap-2 mt-10">
                                  <div class="product-price">
                                    <span class="h6 new-price"><?php echo e(symbolPrice($service->price)); ?></span>
                                    <span
                                      class="prev-price font-sm"><?php echo e($service->prev_price ? symbolPrice($service->prev_price) : ''); ?></span>
                                  </div>
                                  <a href="javaScript:void(0)" class="bookNowBtn btn btn-sm btn-outline-2"
                                    data-bs-toggle="modal" data-bs-target="#makeBooking"
                                    data-id="<?php echo e($service->id); ?>" title="Book Now" target="_self">
                                    <?php echo e(__('Book Now')); ?></a>
                                </div>
                              </div>
                            </div>
                          </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                      <div class="cta-btn text-center mt-15">
                        <a href="<?php echo e(route('frontend.services', ['category_id' => $category->id])); ?>"
                          class="btn btn-lg btn-primary btn-gradient icon-start" target="_self"><i
                            class="fal fa-arrow-right"></i><?php echo e(__('View More')); ?></a>
                      </div>
                    </div>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Service-area end -->
  <?php if(count($after_latest_service) > 0): ?>
    <?php $__currentLoopData = $after_latest_service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusLatestServie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusLatestServie->id])): ?>
        <?php if($homecusSec[$cusLatestServie->id] == 1): ?>
          <?php
            $cusLatestServieContent = App\Models\CustomSectionContent::where('custom_section_id', $cusLatestServie->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusLatestServieContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Shop-area start -->
  <?php if($secInfo->vendor_featured_section_status == 1): ?>
    <section class="shop-area shop-1 pb-100">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <div class="section-title title-inline mb-50" data-aos="fade-up">
              <h2 class="title">
                <?php echo e(!empty($sectionContent->vendor_section_title) ? $sectionContent->vendor_section_title : 'Our Top Featured Vendor'); ?>

              </h2>
              <?php if($vendors > 0): ?>
                <a href="<?php echo e(route('frontend.vendors')); ?>" class="btn btn-lg btn-primary btn-gradient icon-start"
                  title="View All Vendor" target="_self"><i class="fal fa-arrow-right"></i>
                  <?php if($vendors > 1): ?>
                    <?php echo e(__('View All Vendors')); ?>

                  <?php else: ?>
                    <?php echo e(__('View All Vendor')); ?>

                  <?php endif; ?>
                </a>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-12">
            <?php if($featuredVendors->count() == 0): ?>
              <h4 class="text-center"><?php echo e(__('NO VENDOR FOUND') . '!'); ?></h4>
            <?php else: ?>
              <!-- Slider main container -->
              <div class="swiper product-slider" id="product-slider-2" data-slides-per-view="4"
                data-swiper-loop="false" data-aos="fade-up">
                <!-- Additional required wrapper -->
                <div class="swiper-wrapper">
                  <!-- Slides -->
                  <?php $__currentLoopData = $featuredVendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                      <div class="product-default border radius-md p-15 mb-25">
                        <figure class="product-img mb-15">
                          <a href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"
                            title="Image" target="_self" class="lazy-container radius-sm ratio ratio-2-3">
                            <?php if($vendor->photo): ?>
                              <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                data-src="<?php echo e(asset('assets/admin/img/vendor-photo/' . $vendor->photo)); ?>"
                                alt="Vendor">
                            <?php else: ?>
                              <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                data-src="<?php echo e(asset('assets/img/user.png')); ?>" alt="Vendor">
                            <?php endif; ?>
                          </a>
                        </figure>
                        <div class="product-details">
                          <?php
                            $vendorInfo = App\Models\VendorInfo::where([
                                ['vendor_id', $vendor->vendorId],
                                ['language_id', $language->id],
                            ])->first();
                          ?>
                          <h6 class="product-title mb-0">
                            <a href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"
                              target="_self" title="<?php echo e($vendor->username); ?>">
                              <?php if($vendorInfo->name != null): ?>
                                <?php echo e($vendorInfo->name); ?>

                              <?php else: ?>
                                <?php echo e($vendor->username); ?>

                              <?php endif; ?>
                            </a>
                          </h6>
                          <?php if($vendorInfo): ?>
                            <?php if($vendorInfo->address != null): ?>
                              <span class="font-sm icon-start"><i
                                  class="fal fa-map-marker-alt"></i><?php echo e(truncateString($vendorInfo->address, 30)); ?></span>
                            <?php endif; ?>
                          <?php endif; ?>
                          <div class="d-flex align-items-center gap-15 mt-10">
                            <a href="<?php echo e(route('frontend.vendor.details', ['username' => $vendor->username])); ?>"
                              class="btn btn-sm btn-outline-2" title="<?php echo e(__('Visit Store')); ?>"
                              target="_self"><?php echo e(__('Visit Store')); ?></a>
                            <span class="font-sm">
                              <?php if($vendor->total_service > 1): ?>
                                <?php echo e($vendor->total_service); ?>

                                <?php echo e(__('Services Available')); ?>

                              <?php elseif($vendor->total_service == 1): ?>
                                <?php echo e($vendor->total_service); ?>

                                <?php echo e(__('Services Available')); ?>

                              <?php else: ?>
                                <?php echo e(__('No Service Available')); ?>

                              <?php endif; ?>
                            </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- If we need pagination -->
                <div class="swiper-pagination position-static" id="product-slider-2-pagination"></div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <!-- Shop-area end -->
  <?php if(count($after_vendor) > 0): ?>
    <?php $__currentLoopData = $after_vendor; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusVendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusVendor->id])): ?>
        <?php if($homecusSec[$cusVendor->id] == 1): ?>
          <?php
            $cusVendorContent = App\Models\CustomSectionContent::where('custom_section_id', $cusVendor->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusVendorContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Testimonial-area start -->
  <?php if($secInfo->testimonial_section_status == 1): ?>
    <section class="testimonial-area testimonial-1 parallax pb-60">
      <div class="container container-lg-fluid">
        <div class="row align-items-center gx-xl-5">
          <div class="col-lg-6">
            <div class="fluid-left">
              <div class="content-title mb-40" data-aos="fade-up">
                <h2 class="title mb-20">
                  <?php echo e(!empty($sectionContent->testimonial_section_title) ? $sectionContent->testimonial_section_title : 'What Customers Say About Our Booking Systems '); ?>

                </h2>
                <div class="content-text mb-40">
                  <p>
                    <?php echo e(!empty($sectionContent->testimonial_section_subtitle) ? $sectionContent->testimonial_section_subtitle : 'Lorem ipsum dolor sit amet consectetur adipisicing elit. Dolorum omnis natus cumque possimus dicta suscipit enim, aperiam, voluptatum quis deleniti. '); ?>

                  </p>
                </div>
              </div>
              <?php if(count($testimonials) > 0): ?>
                <div class="swiper mb-40" id="testimonial-slider-1" data-aos="fade-up">
                  <div class="swiper-wrapper">
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="swiper-slide">
                        <div class="slider-item radius-md">
                          <div class="client gap-20 flex-wrap">
                            <div class="client-info d-flex align-items-center">
                              <div class="client-img">
                                <div class="lazy-container rounded-pill ratio ratio-1-1">
                                  <img class="lazyload" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                                    data-src="<?php echo e(asset('assets/img/clients/' . $testimonial->image)); ?>"
                                    alt="Person Image">
                                </div>
                              </div>
                              <div class="content">
                                <h6 class="name mb-0"><?php echo e($testimonial->name); ?></h6>
                                <span class="designation font-sm"><?php echo e($testimonial->occupation); ?></span>
                              </div>
                            </div>
                            <div class="rating-area flex-column align-items-start">
                              <div class="ratings">
                                <div class="rate bg-img"
                                  data-bg-image="<?php echo e(asset('assets/frontend/images/rate-star.png')); ?>">
                                  <div class="rating-icon bg-img"
                                    data-bg-image="<?php echo e(asset('assets/frontend/images/rate-star.png')); ?>"
                                    style="width: <?php echo e($testimonial->rating * 20 . '%;'); ?>">
                                  </div>
                                </div>
                              </div>
                              <span class="ratings-total">
                                <?php echo e($testimonial->rating); ?> <?php echo e(__('star of')); ?>

                                <?php echo e($total_testimonial); ?>

                                <?php if($total_testimonial > 1): ?>
                                  <?php echo e(__('reviews')); ?>

                                <?php else: ?>
                                  <?php echo e(__('review')); ?>

                                <?php endif; ?>
                              </span>
                            </div>
                          </div>
                          <div class="quote">
                            <span class="icon"><i class="fal fa-quote-right"></i></span>
                            <p class="text font-lg mb-0">
                              <?php echo e($testimonial->comment); ?>

                            </p>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </div>
                  <div class="swiper-pagination position-static mt-30" id="testimonial-slider-1-pagination">
                  </div>
                </div>
              <?php else: ?>
                <h4><?php echo e(__('NO TESTIMONIAL FOUND')); ?>!</h4>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-lg-6" data-aos="fade-left">
            <div class="image mb-40 parallax-img" data-speed="0.5" data-revert="true">
              <img class="lazyload blur-up" src="<?php echo e(asset('assets/frontend/images/placeholder.png')); ?>"
                data-src="<?php echo e(asset('assets/img/' . @$sectionContent->testimonial_section_image)); ?>" alt="Image">
            </div>
          </div>
        </div>
      </div>
    </section>
  <?php endif; ?>
  <?php if(count($after_testimonial) > 0): ?>
    <?php $__currentLoopData = $after_testimonial; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cusTest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if(isset($homecusSec[$cusTest->id])): ?>
        <?php if($homecusSec[$cusTest->id] == 1): ?>
          <?php
            $cusTestContent = App\Models\CustomSectionContent::where('custom_section_id', $cusTest->id)
                ->where('language_id', $currentLanguageInfo->id)
                ->first();
          ?>
          <?php echo $__env->make('frontend.home.custom-section', ['data' => $cusTestContent], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  <?php endif; ?>
  <!-- Testimonial-area end -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
  <script src="https://js.stripe.com/v3/"></script>
  <script src="<?php echo e($authorizeUrl); ?>"></script>
  <script>
    let stripe_key = "<?php echo e($stripe_key); ?>";
    let authorize_login_key = "<?php echo e($authorize_login_id); ?>";
    let authorize_public_key = "<?php echo e($authorize_public_key); ?>";
    var complete = "<?php echo e(Session::get('complete')); ?>";
    var bookingInfo = <?php echo json_encode(Session::get('paymentInfo')); ?>;
  </script>
  <script src="<?php echo e(asset('assets/frontend/js/appointment.js')); ?>"></script>

  <script>
    <?php if(old('gateway') == 'stripe'): ?>
      $('#stripe-element').removeClass('d-none');
    <?php endif; ?>
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/jdhawkins/Herd/commerce.keepit200/resources/views/frontend/home/index-v1.blade.php ENDPATH**/ ?>