<script>
  'use strict';
  const baseURL = "<?php echo e(url('/')); ?>";
  const all_model = "<?php echo e(__('All')); ?>";
  const read_more = "<?php echo e(__('Read More')); ?>";
  const read_less = "<?php echo e(__('Read Less')); ?>";
  const show_more = "<?php echo e(__('Show More') . '+'); ?>";
  const show_less = "<?php echo e(__('Show Less') . '-'); ?>";
  const langDir = "<?php echo e($currentLanguageInfo->direction); ?>";
  var vapid_public_key = "<?php echo env('VAPID_PUBLIC_KEY'); ?>";
  let bookingUnableText =
    "<?php echo e(__('We regret to inform you that the service you are trying to book is currently unavailable. Please contact our support team for further assistance')); ?>";
</script>
<!-- Jquery JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/jquery.min.js')); ?>"></script>
<!-- Bootstrap JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/bootstrap.min.js')); ?>"></script>
<!-- Data Tables JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/datatables.min.js')); ?>"></script>
<!-- Date-range Picker JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/frontend/js/vendors/daterangepicker.js')); ?>"></script>
<!-- Nice Select JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/jquery.nice-select.min.js')); ?>"></script>
<!-- Magnific Popup JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/jquery.magnific-popup.min.js')); ?>"></script>
<!-- Calendar js -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/pignose.calendar.full.min.js')); ?>"></script>
<!-- Swiper Slider JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/swiper-bundle.min.js')); ?>"></script>
<!-- Lazysizes -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/lazysizes.min.js')); ?>"></script>
<!-- Noui Range Slider JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/nouislider.min.js')); ?>"></script>
<!-- Twinmax JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/tweenMax.min.js')); ?>"></script>
<!-- Simple Parallax JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/parallax.min.js')); ?>"></script>
<!-- AOS JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/aos.min.js')); ?>"></script>
<!-- Mouse Hover JS -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/mouse-hover-move.js')); ?>"></script>
<!-- toastr js -->
<script src="<?php echo e(asset('assets/frontend/js/toastr.min.js')); ?>"></script>
<!-- Stepper js -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/bs-stepper.min.js')); ?>"></script>
<!-- syotimer js -->
<script src="<?php echo e(asset('assets/frontend/js/vendors/jquery.syotimer.min.js')); ?>"></script>
<!-- Main script JS -->
<script src="<?php echo e(asset('assets/frontend/js/script.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/floating-whatsapp.js')); ?>"></script>
<script src="<?php echo e(asset('assets/frontend/js/svg-loader.min.js')); ?>"></script>


<?php if($basicInfo->whatsapp_status == 1): ?>
  <script type="text/javascript">
    var whatsapp_popup = "<?php echo e($basicInfo->whatsapp_popup_status); ?>";
    var whatsappImg = "<?php echo e(asset('assets/img/whatsapp.svg')); ?>";

    $(function() {
      $('#WAButton').floatingWhatsApp({
        phone: "<?php echo e($basicInfo->whatsapp_number); ?>", //WhatsApp Business phone number
        headerTitle: "<?php echo e($basicInfo->whatsapp_header_title); ?>", //Popup Title
        popupMessage: `<?php echo nl2br($basicInfo->whatsapp_popup_message); ?>`, //Popup Message
        showPopup: whatsapp_popup == 1 ? true : false, //Enables popup display
        buttonImage: '<img src="' + whatsappImg + '" />', //Button Image
        position: "right" //Position: left | right
      });
    });
  </script>
<?php endif; ?>
<!--Start of Tawk.to Script-->
<?php if($basicInfo->tawkto_status == 1): ?>
  <script src="<?php echo e(asset('assets/frontend/js/tawk-to.js')); ?>"></script>
  <script type="text/javascript">
    var Tawk_API = Tawk_API || {},
      Tawk_LoadStart = new Date();

    (function() {
      var s1 = document.createElement("script"),
        s0 = document.getElementsByTagName("script")[0];
      s1.async = true;
      s1.src = 'https://embed.tawk.to/<?php echo e($basicInfo->tawkto_direct_chat_link); ?>/default';
      s1.charset = 'UTF-8';
      s1.setAttribute('crossorigin', '*');
      s0.parentNode.insertBefore(s1, s0);
    })();
  </script>
<?php endif; ?>
<!--End of Tawk.to Script-->

<?php echo $__env->yieldContent('script'); ?>
<?php if(session()->has('success')): ?>
  <script>
    "use strict";
    toastr['success']("<?php echo e(__(session('success'))); ?>");
  </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
  <script>
    "use strict";
    toastr['error']("<?php echo e(__(session('error'))); ?>");
  </script>
<?php endif; ?>
<?php if(session()->has('warning')): ?>
  <script>
    "use strict";
    toastr['warning']("<?php echo e(__(session('warning'))); ?>");
  </script>
<?php endif; ?>
<?php /**PATH /Users/jdhawkins/Herd/commerce.keepit200/resources/views/frontend/partials/scripts.blade.php ENDPATH**/ ?>