"use strict";
function formatCurrency(value) {
  if (symbolPosition == 'left') {
    return value < 0 ? `-${symbol}${Math.abs(value)}` : `${symbol}${value}`;
  } else {
    return value < 0 ? `-${Math.abs(value)}${symbol}` : `${value}${symbol}`;
  }
}

$('body').on('change', '#withdraw_method', function () {
  $.get(baseUrl + '/vendor/withdraw/get-method/input/' + $(this).val(), function (data) {
    $('#appned_input').html('');
    var input = '';
    $.each(data, function (key, value) {
      if (value.required == 1) {
        var required = '*'
      } else {
        var required = '';
      }
      if (value.type == 1) {
        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <input type='text' class='form-control' id="${value.name}" name="${value.name}" placeholder="${value.placeholder}">
                  <p id="err_${value.name}" class="mt-2 mb-0 text-danger em"></p>
                </div>`;
      } else if (value.type == 2) {
        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <select class="form-control" id="${value.name}" name="${value.name}">`;
        $.each(value.options, function (k, option) {
          input += `<option value="${option.id}">${option.name}</option>`;
        })
        input += `</select>
            <p id="err_${value.name}" class="mt-2 mb-0 text-danger em"></p>
                </div>`;
      } else if (value.type == 3) {

        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <div class="custom-control custom-checkbox">`;
        $.each(value.options, function (k, option) {
          input += `<div class="custom-control custom-checkbox">
                      <input type="checkbox" id="customRadio${option.id}" name="${value.name}"
                        class="custom-control-input">
                    <label class="custom-control-label"
                        for="customRadio${option.id}">${option.name}</label>
                      </div>`;
        })
        input += `</div>`;
      } else if (value.type == 4) {
        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <textarea class="form-control" id="${value.name}" name="${value.name}" placeholder="${value.placeholder}"></textarea>
                  <p id="err_${value.name}" class="mt-2 mb-0 text-danger em"></p>
                </div>`;
      } else if (value.type == 5) {
        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <input type='date' class='form-control' name="${value.name}" placeholder="${value.placeholder}">
                </div>`;
      } else if (value.type == 6) {
        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <input type='time' class='form-control' name="${value.name}" placeholder="${value.placeholder}">
                </div>`;
      } else if (value.type == 7) {
        input += `<div class='form-group'>
                  <label>${value.label} ${required}</label>
                  <input type='number' class='form-control' id="${value.name}" name="${value.name}" placeholder="${value.placeholder}">
                  <p id="err_${value.name}" class="mt-2 mb-0 text-danger em"></p>
                </div>`;
      }
    });

    $('#appned_input').html(input);
  });

  $("#receive_amount").html('');
  $("#total_charge").html('');
  $("#your_balance").html('');
  $("#total_charge_input").val('');

  var method = $(this).val();

  $.get(baseUrl + '/vendor/withdraw/balance-calculation/' + method + '/' + $('#withdraw_amount').val(), function (data) {
    $("#receive_amount").html(formatCurrency(data.receive_balance));
    $("#total_charge").html(formatCurrency(data.total_charge));
    $("#your_balance").html(formatCurrency(data.user_balance));
  })
})

$('body').on('blur', '#withdraw_amount', function () {
  $("#receive_amount").html('');
  $("#total_charge").html('');
  $("#your_balance").html('');

  var method = $('#withdraw_method').val();

  $.get(baseUrl + '/vendor/withdraw/balance-calculation/' + method + '/' + $(this).val(), function (data) {
    $("#receive_amount").html(formatCurrency(data.receive_balance));
    $("#total_charge").html(formatCurrency(data.total_charge));
    $("#your_balance").html(formatCurrency(data.user_balance));
  })
});

$('body').on('change', '#withdraw_amount', function () {
  $("#receive_amount").html('');
  $("#total_charge").html('');
  $("#your_balance").html('');

  var method = $('#withdraw_method').val();

  $.get(baseUrl + '/vendor/withdraw/balance-calculation/' + method + '/' + $(this).val(), function (data) {
    $("#receive_amount").html(formatCurrency(data.receive_balance));
    $("#total_charge").html(formatCurrency(data.total_charge));
    $("#your_balance").html(formatCurrency(data.user_balance));
  })
});
$('body').on('blur', '#withdraw_amount', function () {
  $("#receive_amount").html('');
  $("#total_charge").html('');
  $("#your_balance").html('');

  var method = $('#withdraw_method').val();

  $.get(baseUrl + '/vendor/withdraw/balance-calculation/' + method + '/' + $(this).val(), function (data) {
    if (data.receive_balance) {
      $('.calculate').removeClass('d-none');
    } else {
      $('.calculate').addClass('d-none');
    }

    $("#receive_amount").html(formatCurrency(data.receive_balance));
    $("#total_charge").html(data.total_charge);
    $('#total_charge_input').val(data.total_charge);
    $("#your_balance").html(formatCurrency(data.user_balance));
  })
});

